/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <gst/gst.h>
#include <aauto/AditVideoSink.h>
#include <aauto/AditEndpointCommon.h>
#include "GstreamerVideoSink.h"

LOG_DECLARE_CONTEXT(aauto_video);

using namespace adit::aauto;

namespace adit { namespace aauto {

AditVideoSink* GstreamerVideoSinkCreate(uint8_t inId, MessageRouter* inRouter,
        bool inAutoStartProjection)
{
    if(inRouter == nullptr)
    {
        LOG_ERROR((aauto_video, "MessageRouter pointer is null"));
        return nullptr;
    }
    
    return new GstreamerVideoSink(inId, inRouter, inAutoStartProjection);
}

/*
 * In case the library is linked at compile time it is more convenient to call unique functions
 * rather than the generic plug-in versions.
 */

void GstreamerEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    // register gstreamer at logging
    LOG_REGISTER_CONTEXT(aauto_video, "VID", "AAUTO video-endpoint");
    LOGD_DEBUG((aauto_video, "aauto-gstreamer git tag: %s", COMP_GIT_VERSION));

    GError* error = nullptr;
    gboolean ret = gst_init_check(NULL, NULL, &error);
    if (ret == TRUE)
    {
        // only register if Gstreamer could initialize
        if (inFactoryRegisterFn != nullptr)
        {
            // it is not required to use the factory
            inFactoryRegisterFn("GstreamerVideoSink", FactoryVideoSink,
                    (CreatorFn)GstreamerVideoSinkCreate);
        }
    }
    else
    {
        if (error != nullptr)
        {
            LOG_ERROR((aauto_video, "gst_init_check failed: %s", error->message));
            g_error_free(error);
        }
        else
        {
            LOG_ERROR((aauto_video, "gst_init_check failed (unknown error)"));
        }

        LOG_FATAL((aauto_video, "unable to register Gstreamer adapters"));
    }
}

void GstreamerExitPoint()
{
    LOG_UNREGISTER_CONTEXT(aauto_video);
}

} } // namespace adit { namespace aauto {

extern "C" void aauto_LibraryEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    GstreamerEntryPoint(inFactoryRegisterFn);
}

extern "C" void aauto_LibraryExitPoint()
{
    GstreamerExitPoint();
}
